///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Server
{
    public:
        // --------------(Function Prototypes)-----------------------------------------------------
        bool FreeClientSend(int);			        // Frees the clients send memory
        bool FreeClientReceive(int);			    // Frees the clients receive memory
        bool FreeClientSendReceive(int);		    // Frees the clients send & receive memory

        int SelectFreeClient(void); 			    // Search for free client "Slot"
        bool DisconnectClient(int); 			    // Disconnect client

        char *PeekSendData(int);
        char *PeekReceiveData(int);
        int PeekSizeOfSendData(int);
        int PeekSizeOfReceiveData(int);

        bool IsDataReady(int);
        bool SetSendData(int, char *);
        bool SetSendDataEx(int, char *, int);
        bool GetReceiveData(int, char *, int *);

        bool DoSendData(int);					    // Send data to remote client
		bool DoReceiveData(int);				    // Receive data from remote client

        int Connect(char *, int);				    // Connect to remote client
        int AcceptConnection(void); 			    // Accept connection from remote client

        bool Start(int);				            // Starts the service on a specific port
        bool Stop(void); 				            // Stops the service

        int RawWriteClientEx(int, char *, int);
        int WriteLineToClient(int, char *);			// Write string to remote client
        int WriteLineToClientEx(int, char *, int);  // Write unicode string to remote client

        Server::Server(void);  // Class constructor
        Server::~Server(void); // Class destructor

        // Thread management
        bool CreateNewTCPThread(void);
        bool SuspendTCPThread(void);           // Suspend the TCPThread
        bool ResumeTCPThread(void);            // Resume the TCPThread
        bool KillTCPThread(void);              // Terminate the TCPThread
        bool IsTCPThreadActive(void);          // Check TCPThread for activity

        // --------------(Variable Declerations)-----------------------------------------------------
    	bool Connected[MAXCLIENTS+1];		   // Remote client's connection flag
    	bool Disconnect[MAXCLIENTS+1];		   // Remote client's disconnect flag
    	int Connections;					   // Number of remote clients
    	SOCKET Socket[MAXCLIENTS+1];		   // Remote client's socket
        bool RawMode[MAXCLIENTS+1];            //-
        int RecvOffset[MAXCLIENTS+1];

        DWORD DisconnectTime[MAXCLIENTS+1];    // The DWORD time that the client will be disconnected.

        // Socket Variables
        SOCKET LocalListenSocket;			   // Listen Socket Of Local Server

        fd_set ReadFDS; 					   // FDS Read
        fd_set WriteFDS;					   // FDS Write
        fd_set ExceptFDS;					   // FDS Except

        struct timeval TimeOut; 			   // TimeOut

        // Thread Variables
        DWORD Client_Thread_ID[MAXCLIENTS+1];
        HANDLE Client_Thread_Handle[MAXCLIENTS+1];

        friend DWORD WINAPI Client_Thread(LPVOID);
        friend DWORD WINAPI _TCPThreadFunction(LPVOID);
        friend DWORD ThreadWaitForDisconnect(Server *pServer, int Client);
        friend bool IsUserAlreadyConnected(Server *, char *); // Non standard. User addon!

    	int ClientID[MAXCLIENTS+1];	             // Remote client's ID (For client tracking)

    protected:
        // --------------(Variable Declerations)-----------------------------------------------------
    	char *SendData[MAXCLIENTS+1];		     // Remote client's data to be sent
    	int SizeOfSendData[MAXCLIENTS+1];	     // Remote client's size of data to be sent (Bytes)

    	char *ReceiveData[MAXCLIENTS+1];	     // Remote client's receive buffer
    	int SizeOfReceiveData[MAXCLIENTS+1];     // Remote client's size of received data (Bytes)

        int NextClientID;                        // The next assigned Client ID

        HANDLE TCPThreadHandle;                  // Thread handle
        bool TCPThreadActive;                    // Activity indicator
        DWORD TCPThreadID;                       // Thread ID

        bool IsClientThreadActive[MAXCLIENTS+1]; // Used when accepting conections to wait untill client thread starts.
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Server::Server(void)
{
    int ClientLoop = 0;
    while(ClientLoop < MAXCLIENTS)
    {
        Socket[ClientLoop]     = 0;

        Connected[ClientLoop]  = false;
        Disconnect[ClientLoop] = false;

        RawMode[ClientLoop]    = false;

    	SendData[ClientLoop]    = NULL;
    	ReceiveData[ClientLoop] = NULL;

        DisconnectTime[ClientLoop]    = -1;
        RecvOffset[ClientLoop]        = 0;
    	SizeOfSendData[ClientLoop]    = 0;
    	SizeOfReceiveData[ClientLoop] = 0;
        ClientID[ClientLoop]          = 0;

        IsClientThreadActive[ClientLoop] = false;

        ClientLoop++;
    }

    NextClientID    = 0;
    Connections     = 0;

    TCPThreadHandle = NULL;
    TCPThreadActive = false;
    TCPThreadID     = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Server::~Server(void)
{
    Connections = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "TCP/Functions.H"

#include "TCP/TCPBuffer.H"

#include "TCP/Start.H"
#include "TCP/Stop.H"

#include "TCP/ClientThread.H"
#include "TCP/Threading.H"

#include "TCP/Accept.H"
#include "TCP/Connect.H"

#include "TCP/Send.H"
#include "TCP/Receive.H"

Server MyServer;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

